#ifndef __EVOLVE_H__
#define __EVOLVE_H__

#include "routine.h"
#include "agent.h"
#include "field.h"

typedef struct {
	char *agentclass_from;
	char *agentclass_to;
	AGENTCLASS *ac_from;
	AGENTCLASS *ac_to;
	ROUTINE *condition;
	char *condition_name;
	long * condition_parameters;
	ROUTINE **evolve;
	char **evolve_name;
	long * *evolve_parameters;
	} EVOLUTION_RULE;

void init_evolution_rules(void);
void generate_evolution_data(void);
AGENT *get_current_agent(void);
FIELD *get_current_field(void);
void set_current_field(FIELD *f);
void dump_rules(FILE *fout);
EVOLUTION_RULE *add_new_rule(char *from,char *to);
void set_rule_condition(EVOLUTION_RULE *ev, char *cond);
void set_rule_evolve_attr(EVOLUTION_RULE *ev, char *attr_name, char *routine);
void evolve_fields(void);
int evaluate_attribute(long index, u64 *result);
void set_current_agent(long i,long j);

#endif
